/**
 *  Author: Hannes Hassler 
 *  Status: in development.
 *  Reads commands plus parameters from a ASCII text file xy values.
 *
 */

function main() {
  /*
  Folgender Pfad muss an den Installationsort von QCAD angepasst werden.
  */
  var filename = "C:\\Program Files (x86)\\QCAD Professional\\scripts\\inputxyGenerated.txt";  

  var doc;       // current document
  var view;      // current document view
  var line;      // line to add
  var i;         // counter
  var factor;    // scaling factor
  var lx = -1.0;
  var ly = -1.0;
  var x;
  var y;
  
  var fx;
  var fy;
  
  var file;  

  var aLine;
  var bLine;
  
  doc = new Document;
  view = new View;
  
  factor = new Vector(1,1);

  try {
    file = new File(filename);
    file.open(1);

    var re = /(.*),(.*),(.*),(.*),(.*),/;  // comma separated list 
    var command; //type 
    var num_x; // 1st point x
    var num_y; // 1st point y
    var num_bx;  // 2nd point x
    var num_by;  // 2nd point y
    var line;
    
    var center_x;
    var center_y;
    var radius;
    var circle;
    
    
    while  ( line = file.readLine() ) {
      
      //print(line); 
      line.match(re);
      command = re.capturedTexts[1];
      
      
      if (command=="factor") {
	 //print("is factor");      
	 fx=parseFloat( re.capturedTexts[2] );
	 fy=parseFloat( re.capturedTexts[3] );
	 factor = new Vector(fx,fy);
      }
      
      
      if (command=="line") {
	 //print("is line");
         num_x = parseFloat( re.capturedTexts[2] );
         num_y = parseFloat( re.capturedTexts[3] );
   
         num_bx = parseFloat( re.capturedTexts[4] );
         num_by = parseFloat( re.capturedTexts[5] );
    
         lx = num_x;   
         ly = num_y;   
  
         x = num_bx;   
         y = num_by;   

         line = new Line(doc, lx*factor.x, ly*factor.y,
                          x*factor.x,  y*factor.y);
         doc.addEntity(line);
	 view.redraw(); 
      }  
      
      if (command=="circle") {
	 center_x=parseFloat( re.capturedTexts[2] );
	 center_y=parseFloat( re.capturedTexts[3] );
	 radius  =parseFloat( re.capturedTexts[4] );
	 
	 circle = new Circle(doc, center_x, center_y, radius);
	 doc.addEntity(circle);
	 view.redraw();	 
      }
      
     
    } 

  }
  finally {
    file.close();
  }

  print("DEBUG: End of File reached.");     

  view.redraw();

  print("All done.");
}


// EOF.
